set autoscale 
set xtic auto 
set ytic auto 
set style line  1 lt 1 lw 1 lc rgb "#000000"
set style line  2 lt 1 lw 1 lc rgb "#FF0000"
set style line  3 lt 1 lw 1 lc rgb "#008000"

set xlabel "E (eV)" font "Times,12"
set ylabel "Intensity (arb. units)" font "Times,12"

set out "XASpartialSpec.ps"
set size 1.0, 1.0
set terminal postscript portrait enhanced color  "Times" 12

set multiplot layout 5, 1

plot "XASSpec.dat"  u 1:(-$3 ) title 'x-total Sz=-1' with lines ls  1,\
     "XASSpec.dat"  u 1:(-$5 ) title 'x-eg    Sz=-1' with lines ls  2,\
     "XASSpec.dat"  u 1:(-$7 ) title 'x-t2g   Sz=-1' with lines ls  3

plot "XASSpec.dat"  u 1:(-$3 ) title 'x total Sz=-1' with lines ls  1,\
     "XASSpec.dat"  u 1:(-$9 ) title 'x-j=1/2 Sz=-1' with lines ls  2,\
     "XASSpec.dat"  u 1:(-$11) title 'x-j=3/2 Sz=-1' with lines ls  3

plot "XASSpec.dat"  u 1:(-$3 ) title 'x total Sz=-1' with lines ls  1,\
     "XASSpec.dat"  u 1:(-$13) title 'x-d8    Sz=-1' with lines ls  2,\
     "XASSpec.dat"  u 1:(-$15) title 'x-d9    Sz=-1' with lines ls  3

